/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkEvent;
import com.ibm.hwmca.fw.util.WorkListener;
import com.ibm.hwmca.fw.util.WorkPerformer;
import com.ibm.hwmca.fw.util.WorkThread;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UnacceptableManagedObjects
implements PropertyChangeListener {
    public static final String STATE_PROPERTY = "StateProperty";
    public static final String COUNT_PROPERTY = "CountProperty";
    private ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
    private ArrayList unacceptable = new ArrayList();
    private HashMap listeners;
    private static ObjectId[] ALL_ACCEPTABLE = new ObjectId[0];
    private Object lock = new Object();
    private Object listenerLock = new Object();
    private ObjectId myObjectId;
    private Worker worker;
    private static UnacceptableManagedObjects instance;
    private static final FrameworkClassLogInfo logInfo;
    private static final String TRACE_MASKT = "XUNACCPT";
    private static final String TRACE_MASKF = "XUNACCPF";
    private static final String TRACE_MASKD = "XUNACCPD";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;

    private UnacceptableManagedObjects() {
    }

    public static UnacceptableManagedObjects getUnacceptableManagedObjects() {
        if (instance == null) {
            throw new IllegalStateException("Error, the UnacceptableManagedObjects singleton is null.");
        }
        return instance;
    }

    public ObjectId getObjectId() {
        return this.myObjectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUnacceptableObjectIds() {
        Trace.trace(TRACE_MASKT, "-> UnacceptableManagedObjects.getUnacceptableObjectIds()");
        ArrayList<ObjectId> result = new ArrayList<ObjectId>();
        UserContext userContext = UserContext.getCurrentUserContext();
        Object object = this.lock;
        synchronized (object) {
            if (this.unacceptable != null) {
                Iterator iterator = this.unacceptable.iterator();
                while (iterator.hasNext()) {
                    ObjectId nextId = (ObjectId)iterator.next();
                    if (!this.mom.isObjectAllowed(nextId, userContext)) continue;
                    result.add(nextId);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- UnacceptableManagedObjects.getUnacceptableObjectIds(), number returned is " + result.size());
        return result;
    }

    public boolean isUnacceptable() {
        return this.isUnacceptable(UserContext.getCurrentUserContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnacceptable(UserContext userContext) {
        boolean result = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.unacceptable != null) {
                Iterator iterator = this.unacceptable.iterator();
                while (iterator.hasNext() && !result) {
                    ObjectId nextId = (ObjectId)iterator.next();
                    if (!this.mom.isObjectAllowed(nextId, userContext)) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener, String propertyName) {
        this.addPropertyChangeListener(listener, propertyName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener, String propertyName, boolean initial) {
        Trace.trace(TRACE_MASKT, "-> UnacceptableManagedObjects.addPropertyChangeListener()");
        ListenerData listenerData = new ListenerData(listener, propertyName, UserContext.getCurrentUserContext());
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new HashMap();
            }
            this.listeners.put(listener, listenerData);
        }
        List list = this.getUnacceptableObjectIds();
        listenerData.add(list);
        if (initial) {
            PropertyChangeEvent evt = null;
            if (list.isEmpty()) {
                if (propertyName.equals(COUNT_PROPERTY)) {
                    Integer numObjects = new Integer(0);
                    evt = new PropertyChangeEvent(this.myObjectId, STATE_PROPERTY, null, numObjects);
                } else {
                    evt = propertyName.equals(STATE_PROPERTY) ? new PropertyChangeEvent(this.myObjectId, "StatusAcceptable", null, Boolean.TRUE) : new PropertyChangeEvent(this.myObjectId, "StatusAcceptable", null, ALL_ACCEPTABLE);
                }
            } else if (propertyName.equals(COUNT_PROPERTY)) {
                int num = listenerData.add(list);
                Integer numObjects = new Integer(num);
                evt = new PropertyChangeEvent(this.myObjectId, STATE_PROPERTY, null, numObjects);
            } else if (propertyName.equals(STATE_PROPERTY)) {
                evt = new PropertyChangeEvent(this.myObjectId, STATE_PROPERTY, null, Boolean.FALSE);
            } else {
                ObjectId[] ids = new ObjectId[list.size()];
                ids = list.toArray(ids);
                evt = new PropertyChangeEvent(this.myObjectId, "StatusAcceptable", null, ids);
            }
            listener.propertyChange(evt);
        }
        Trace.trace(TRACE_MASKT, "<- UnacceptableManagedObjects.addPropertyChangeListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }

    private void init() {
        this.worker = new Worker(this);
        this.myObjectId = new ObjectId(this);
        ClassId[] types = new ClassId[]{new ClassId(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = UnacceptableManagedObjects.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject)};
        this.mom.addPropertyChangeListener((PropertyChangeListener)this, true, types);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Trace.trace(TRACE_MASKT, "-> UnacceptableManagedObjects.propertyChange()");
        this.worker.requestWork(evt);
        Trace.trace(TRACE_MASKT, "<- UnacceptableManagedObjects.propertyChange()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logInfo = new FrameworkClassLogInfo(85, "UnacceptManObj");
    }

    public static final class Init
    implements Runnable {
        public void run() {
            Trace.trace(UnacceptableManagedObjects.TRACE_MASKT, "-> UnacceptableManagedObjects#Init.run()");
            instance = new UnacceptableManagedObjects();
            instance.init();
            Trace.trace(UnacceptableManagedObjects.TRACE_MASKT, "<- UnacceptableManagedObjects#Init.run()");
        }
    }

    class ListenerData {
        UserContext userContext;
        PropertyChangeListener listener;
        String propertyName;
        boolean unacceptableObjectsExist = true;
        int unacceptableCount;

        ListenerData(PropertyChangeListener listener, String propertyName, UserContext userContext) {
            this.listener = listener;
            this.propertyName = propertyName;
            this.userContext = userContext;
            if (propertyName.equals(UnacceptableManagedObjects.STATE_PROPERTY)) {
                this.unacceptableObjectsExist = UnacceptableManagedObjects.this.isUnacceptable(userContext);
            }
        }

        int getUnacceptableCount() {
            return this.unacceptableCount;
        }

        int add(List unacceptableObjectIds) {
            this.unacceptableCount += unacceptableObjectIds.size();
            return this.unacceptableCount;
        }

        int remove(List unacceptableObjectIds) {
            this.unacceptableCount -= unacceptableObjectIds.size();
            return this.unacceptableCount;
        }
    }

    private class Worker
    implements WorkPerformer,
    WorkListener {
        private WorkThread workThread;
        private UnacceptableManagedObjects instance;

        public Worker(UnacceptableManagedObjects instance) {
            this.instance = instance;
            this.workThread = new WorkThread("UnacceptableManagedObject.Worker");
            this.workThread.startWorker();
        }

        public void requestWork(PropertyChangeEvent evt) {
            this.workThread.requestWork(this, this, "ProperyChangeEvent", evt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object performWork(Object data) throws Throwable {
            Object acceptable;
            Trace.trace(UnacceptableManagedObjects.TRACE_MASKT, " -> Worker.performWork()");
            PropertyChangeEvent evt = (PropertyChangeEvent)data;
            ArrayList<ObjectId> addedIds = new ArrayList<ObjectId>();
            ArrayList<ObjectId> removedIds = new ArrayList<ObjectId>();
            ObjectId source = (ObjectId)evt.getSource();
            int oldUnacceptableSize = 0;
            int newUnacceptableSize = 0;
            Object object = UnacceptableManagedObjects.this.lock;
            synchronized (object) {
                oldUnacceptableSize = UnacceptableManagedObjects.this.unacceptable.size();
                if (source.equals(UnacceptableManagedObjects.this.mom.getObjectId())) {
                    int i;
                    ObjectId[] ids = (ObjectId[])evt.getOldValue();
                    if (ids == null) {
                        ids = (ObjectId[])evt.getNewValue();
                        for (i = 0; i < ids.length; ++i) {
                            UnacceptableManagedObjects.this.mom.addPropertyChangeListener(ids[i], "StatusAcceptable", this.instance, false);
                            acceptable = (Boolean)UnacceptableManagedObjects.this.mom.getProperty(ids[i], "StatusAcceptable");
                            Trace.trace(UnacceptableManagedObjects.TRACE_MASKT, "   acceptable status is " + acceptable);
                            if (((Boolean)acceptable).booleanValue()) continue;
                            UnacceptableManagedObjects.this.unacceptable.add(ids[i]);
                            addedIds.add(ids[i]);
                        }
                    } else {
                        for (i = 0; i < ids.length; ++i) {
                            if (!UnacceptableManagedObjects.this.unacceptable.remove(ids[i])) continue;
                            removedIds.add(ids[i]);
                            UnacceptableManagedObjects.this.mom.removePropertyChangeListener(ids[i], "StatusAcceptable", this.instance);
                        }
                    }
                } else {
                    Boolean acceptable2 = (Boolean)evt.getNewValue();
                    if (acceptable2.booleanValue()) {
                        if (UnacceptableManagedObjects.this.unacceptable.remove(source)) {
                            removedIds.add(source);
                        }
                    } else if (!UnacceptableManagedObjects.this.unacceptable.contains(source)) {
                        UnacceptableManagedObjects.this.unacceptable.add(source);
                        addedIds.add(source);
                    }
                }
                newUnacceptableSize = UnacceptableManagedObjects.this.unacceptable.size();
                Trace.trace(UnacceptableManagedObjects.TRACE_MASKF, "   there are " + newUnacceptableSize + " unacceptable objects in the system user context.");
            }
            int numAdded = addedIds.size();
            int numRemoved = removedIds.size();
            Trace.trace(UnacceptableManagedObjects.TRACE_MASKF, "   numAdded is " + numAdded + ", numRemoved is " + numRemoved);
            if (numAdded > 0 || numRemoved > 0) {
                Collection listenersClone = null;
                acceptable = UnacceptableManagedObjects.this.listenerLock;
                synchronized (acceptable) {
                    if (UnacceptableManagedObjects.this.listeners != null) {
                        listenersClone = ((Map)UnacceptableManagedObjects.this.listeners.clone()).values();
                    }
                }
                if (listenersClone != null) {
                    Trace.trace(UnacceptableManagedObjects.TRACE_MASKF, "   number of listeners is " + listenersClone.size());
                    PropertyChangeEvent pce = null;
                    ArrayList<ObjectId> allowedIds = new ArrayList<ObjectId>();
                    ArrayList<ObjectId> idList = numAdded > 0 ? addedIds : removedIds;
                    Iterator iterator = listenersClone.iterator();
                    while (iterator.hasNext()) {
                        ListenerData listenerData = (ListenerData)iterator.next();
                        int oldUnacceptableCount = listenerData.getUnacceptableCount();
                        for (int i = 0; i < idList.size(); ++i) {
                            ObjectId id = (ObjectId)idList.get(i);
                            if (!UnacceptableManagedObjects.this.mom.isObjectAllowed(id, listenerData.userContext)) continue;
                            allowedIds.add(id);
                        }
                        int newUnacceptableCount = 0;
                        newUnacceptableCount = numAdded > 0 ? listenerData.add(allowedIds) : listenerData.remove(allowedIds);
                        Trace.trace(UnacceptableManagedObjects.TRACE_MASKF, "   oldUnacceptableCount is " + oldUnacceptableCount + ", newUnacceptableCount is " + newUnacceptableCount);
                        if (oldUnacceptableCount != newUnacceptableCount) {
                            if (listenerData.propertyName.equals(UnacceptableManagedObjects.COUNT_PROPERTY)) {
                                pce = new PropertyChangeEvent(UnacceptableManagedObjects.this.myObjectId, UnacceptableManagedObjects.STATE_PROPERTY, new Integer(oldUnacceptableCount), new Integer(newUnacceptableCount));
                                listenerData.listener.propertyChange(pce);
                            } else if (listenerData.propertyName.equals(UnacceptableManagedObjects.STATE_PROPERTY)) {
                                Boolean newValue = null;
                                Boolean oldValue = null;
                                if (oldUnacceptableCount == 0 && newUnacceptableCount > 0) {
                                    newValue = Boolean.FALSE;
                                    oldValue = Boolean.TRUE;
                                } else if (oldUnacceptableCount > 0 && newUnacceptableCount == 0) {
                                    oldValue = Boolean.FALSE;
                                    newValue = Boolean.TRUE;
                                }
                                if (newValue != null) {
                                    pce = new PropertyChangeEvent(UnacceptableManagedObjects.this.myObjectId, UnacceptableManagedObjects.STATE_PROPERTY, oldValue, newValue);
                                    listenerData.listener.propertyChange(pce);
                                }
                            } else if (allowedIds.size() > 0) {
                                ObjectId[] ids = new ObjectId[allowedIds.size()];
                                ids = allowedIds.toArray(ids);
                                pce = numAdded > 0 ? new PropertyChangeEvent(UnacceptableManagedObjects.this.myObjectId, "StatusAcceptable", null, ids) : new PropertyChangeEvent(UnacceptableManagedObjects.this.myObjectId, "StatusAcceptable", ids, null);
                                listenerData.listener.propertyChange(pce);
                            }
                        }
                        allowedIds.clear();
                    }
                }
            }
            Trace.trace(UnacceptableManagedObjects.TRACE_MASKT, " <- Worker.performWork()");
            return null;
        }

        public void workCompleted(WorkEvent event) {
            Trace.trace(UnacceptableManagedObjects.TRACE_MASKT, " <> Worker.workCompleted()");
            if (event.hasException()) {
                event.getException().printStackTrace();
                HException hexc = new HException(event.getException());
                new FrameworkLog(logInfo, 1043, hexc).log();
            }
        }
    }
}

